IF EXISTS ( SELECT 1 FROM SYS.TRIGGERS WHERE NAME = 'TRG_EST_PROD_TBL_DESC_INTEGRA_PROPZ_EVENTOS' )
BEGIN
	DROP TRIGGER TRG_EST_PROD_TBL_DESC_INTEGRA_PROPZ_EVENTOS
END
GO
CREATE TRIGGER TRG_EST_PROD_TBL_DESC_INTEGRA_PROPZ_EVENTOS ON EST_PROD_TBL_DESC
FOR INSERT, UPDATE 
AS  
  UPDATE A SET 
    A.ST_EVENTO = 4 
  FROM INSERTED I 
  JOIN INTEGRA_PROPZ_EVENTOS A ON(I.CD_TBL_DESC = A.CD_REGISTRO)
  WHERE A.ST_EVENTO = 3
  AND A.TABELA = 'EST_PROD_TBL_DESC'

  INSERT INTO INTEGRA_PROPZ_EVENTOS(TABELA, CD_EMP, CD_FILIAL, CD_REGISTRO, TP_EVENTO, DT_ULT_ALT, CD_USU, DT_DOCUMENTO)
  SELECT	
    'EST_PROD_TBL_DESC'                           AS TABELA,
	EST_PROD_TBL_DESC.CD_EMP                      AS CD_EMP,
	0                                             AS CD_FILIAL,
	EST_PROD_TBL_DESC.CD_TBL_DESC                 AS CD_REGISTRO,
	1                                             AS TP_EVENTO,
	EST_PROD_TBL_DESC.DT_ULT_ALT                  AS DT_ULT_ALT,
	EST_PROD_TBL_DESC.CD_USU                      AS CD_USU,
	GETDATE()                                     AS DT_DOCUMENTO	
  FROM INSERTED EST_PROD_TBL_DESC
  WHERE EST_PROD_TBL_DESC.CD_EMP = 1
  AND EST_PROD_TBL_DESC.FLAG_ENVIO_PROPZ = 1